package gov.va.med.mhv.admin.ldap;

import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.props.WeblogicJndiDataSourcePropertySourceFactory;

@Component
@PropertySource(value = "MHVDB", name = "jdbc/mhvDS:ADMIN_PORTAL_WS", factory = WeblogicJndiDataSourcePropertySourceFactory.class)
public class LdapEnvironment implements Serializable {

	private static final long serialVersionUID = 3719104006793507494L;

	private Log log = LogFactory.getLog(getClass());

	@Value("${ad.initial.ctx.factory}")
	private String adIntialCtxFactory;

	@Value("${ad.security.auth}")
	private String adSecurityAuthentication;

	@Value("${ad.ldap.url}")
	private String adUrl;

	@Value("${ad.ldap.adminPrincipal}")
	private String adAdminPrincipal;

	@Value("${ad.ldap.adminPassword}")
	private String adAdminPassword;

	@Value("${ad.ldap.searchBase}")
	private String adSearchBase;

	public String getAdIntialCtxFactory() {
		return adIntialCtxFactory;
	}

	public void setAdIntialCtxFactory(String adIntialCtxFactory) {
		this.adIntialCtxFactory = adIntialCtxFactory;
	}

	public String getAdSecurityAuthentication() {
		return adSecurityAuthentication;
	}

	public void setAdSecurityAuthentication(String adSecurityAuthentication) {
		this.adSecurityAuthentication = adSecurityAuthentication;
	}

	public String getAdUrl() {
		return adUrl;
	}

	public void setAdUrl(String adUrl) {
		this.adUrl = adUrl;
	}

	public String getAdAdminPrincipal() {
		return adAdminPrincipal;
	}

	public void setAdAdminPrincipal(String adAdminPrincipal) {
		this.adAdminPrincipal = adAdminPrincipal;
	}

	public String getAdAdminPassword() {
		return adAdminPassword;
	}

	public void setAdAdminPassword(String adAdminPassword) {
		this.adAdminPassword = adAdminPassword;
	}

	public String getAdSearchBase() {
		return adSearchBase;
	}

	public void setAdSearchBase(String adSearchBase) {
		this.adSearchBase = adSearchBase;
	}

	/*
	 * private void init() throws InvocationTargetException,
	 * IllegalAccessException, IOException { //TODO: Geetha 2/11/2015
	 * //Properties props = ConfigurationManager.getConfiguration( CFG_FILE );
	 * Properties props = new Properties();
	 * 
	 * try {
	 * props.load(this.getClass().getClassLoader().getResourceAsStream(CFG_FILE)
	 * ); } catch (IOException e) { log.error(
	 * String.format("Error in loading property file %S", CFG_FILE)); }
	 * 
	 * PropertyDescriptor[] pdArray =
	 * BeanUtils.getPropertyDescriptors(getClass()); for(int i = 0; i <
	 * pdArray.length; i++) { PropertyDescriptor pd = pdArray[i]; Method
	 * writeMethod = pd.getWriteMethod();
	 * 
	 * if(writeMethod == null) continue;
	 * 
	 * String key = pd.getName(); String strValue = props.getProperty(key);
	 * 
	 * if(strValue == null) continue;
	 * 
	 * Class valueType = pd.getPropertyType(); if(valueType == String.class)
	 * writeMethod.invoke(this, new Object[]{strValue}); else if(valueType ==
	 * int.class) { writeMethod.invoke(this, new Object[]{new
	 * Integer(strValue)}); } } }
	 */

	public String toString() {
		StringBuffer buf = new StringBuffer();

		if (log.isDebugEnabled()) {
			String sep = System.getProperty("line.separator");
			buf.append("=========================").append(sep).append("LdapEnvironment [" + hashCode() + "]")
					.append(sep);

			PropertyDescriptor[] pds = BeanUtils.getPropertyDescriptors(getClass());
			for (int i = 0; i < pds.length; i++) {
				PropertyDescriptor pd = pds[i];
				Method readMethod = pd.getReadMethod();

				if (readMethod != null) {
					Class returnType = readMethod.getReturnType();
					Class[] params = readMethod.getParameterTypes();
					String name = readMethod.getName();

					if (params.length == 0 && returnType != Class.class && name.startsWith("get")) {
						Object value = null;

						try {
							value = readMethod.invoke(this, null);
						} catch (Throwable t) {
							value = "!!error!!";
						}

						buf.append(name).append('=').append(value).append(sep);
					}
				}
			}
			buf.append("=========================");
		}
		return buf.toString();
	}
}